#include <maps/wikimap/mapspro/services/mrc/libs/birdview/include/utility.h>

#include <maps/libs/common/include/exception.h>

namespace maps::mrc::birdview {

cv::Rect findBoxOfPerspectiveTransform(const cv::Rect& rect,
                                       const cv::Mat& transformationMatrix)
{
    const std::array<cv::Point2f, 4> src
        = {rect.tl(),
           {(float)rect.br().x, (float)rect.tl().y},
           rect.br(),
           {(float)rect.tl().x, (float)rect.br().y}};
    std::array<cv::Point2f, 4> dest;
    cv::perspectiveTransform({src.data(), src.size()},
                             {dest.data(), dest.size()},
                             transformationMatrix);
    return cv::boundingRect({dest.data(), dest.size()});
}

} // namespace maps::mrc::birdview
