#pragma once

#include <contrib/libs/opencv/include/opencv2/opencv.hpp>

namespace maps::mrc::birdview {

/**
 * Prepare birdview for road marking overview.
 * @param vanishingPoint - @see https://en.wikipedia.org/wiki/Vanishing_point
 * @param srcHeight - input image height;
 * @param destSize - output image size (birdview).
 *
 * Example:
 * @code
 * cv::Size SIZE{800, 800};
 * auto transform = findBirdviewTransformationMatrix(vanishingPoint,
                                                     img.rows, SIZE);
 * cv::Mat birdview;
 * cv::warpPerspective(img, birdview, transform, SIZE);
 * @endcode
 */
cv::Mat findBirdviewTransformationMatrix(const cv::Point2f& vanishingPoint,
                                         int srcHeight,
                                         const cv::Size& destSize);

} // namespace maps::mrc::birdview
