#pragma once

#include <contrib/libs/opencv/include/opencv2/opencv.hpp>

namespace maps::mrc::birdview {

/**
 * Find the car dashboard in a series of photos (same size).
 * @return panel start row or -1 on failure.
 */
class PanelDetector {
public:
    int update(const cv::Mat& image);
    int panelRow() const { return std::floor(panelRow_); }

private:
    cv::Mat gradientMagnitude_;
    cv::Size size_;
    float panelRow_{-1.0};
};

} // namespace maps::mrc::birdview
