#pragma once

#include <contrib/libs/opencv/include/opencv2/opencv.hpp>

namespace maps::mrc::birdview {

/**
 * @return bounding rect of perspective transform
 * @param rect - to be transformed
 * @param transformationMatrix - 3x3 floating-point transformation matrix
 *
 * Example:
 * @code
 * auto imageSign = findBoxOfPerspectiveTransform(birdviewSign,
 *    homography.inv());
 * @endcode
 */
cv::Rect findBoxOfPerspectiveTransform(const cv::Rect& rect,
                                       const cv::Mat& transformationMatrix);

} // namespace maps::mrc::birdview
