#pragma once

#include <contrib/libs/opencv/include/opencv2/opencv.hpp>

#include <optional>
#include <vector>

namespace maps::mrc::birdview {

using Line = cv::Vec4i;

/**
 * @return vanishing point and confidence;
 * @param lines - finded by cv::LineSegmentDetector in the input image.
 *
 * Example:
 * @code
 * cv::Mat gray;
 * cv::cvtColor(img, gray, cv::COLOR_BGR2GRAY);
 * auto lineDetector = cv::createLineSegmentDetector(cv::LSD_REFINE_STD, 0.5);
 * std::vector<cv::Vec4i> lines;
 * lineDetector->detect(gray, lines);
 * auto [point, weight] = findVanishingPoint(lines, gray.size());
 * @endcode
 */
std::pair<cv::Point2f, float>
findVanishingPoint(const std::vector<Line>& lines, const cv::Size& imageSize);

std::optional<cv::Point> findVanishingPoint(const cv::Mat& image);

} // namespace maps::mrc::birdview
