#pragma once

#include <maps/libs/auth/include/blackbox.h>

#include <cstdint>
#include <optional>
#include <string>
#include <unordered_map>
#include <vector>

namespace maps::mrc::blackbox_client {

using Uid = uint64_t;
using Uids = std::vector<Uid>;
using UserInfo = auth::UserInfo;
using UidToLoginMap = std::unordered_map<Uid, std::string>;
using UidToUserInfoMap = std::unordered_map<Uid, UserInfo>;
using QueryParams = auth::BlackboxQueryParams;

struct IBlackboxClient {
    virtual ~IBlackboxClient() = default;
    virtual std::optional<Uid> uidByLogin(const std::string& login) const = 0;
    virtual UidToLoginMap uidToLoginMap(Uids /* sink */) const = 0;
    virtual UidToUserInfoMap uidToUserInfoMap(Uids /* sink */, const QueryParams&) const = 0;
};

class BlackboxClient : public IBlackboxClient {
    auth::BlackboxApi blackboxApi_;

public:
    explicit BlackboxClient(const auth::TvmtoolSettings& tvm)
        : blackboxApi_(tvm)
    {
    }

    std::optional<Uid> uidByLogin(const std::string& login) const override;
    UidToLoginMap uidToLoginMap(Uids) const override;
    UidToUserInfoMap uidToUserInfoMap(Uids, const QueryParams&) const override;
};

struct Stub : IBlackboxClient {
    std::optional<Uid> uidByLogin(const std::string&) const override { return {}; }
    UidToLoginMap uidToLoginMap(Uids) const override { return {}; }
    UidToUserInfoMap uidToUserInfoMap(Uids, const QueryParams&) const override { return {}; }
};

} // namespace maps::mrc::blackbox_client
