#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/camera/include/camera_parameters.h>
#include <maps/libs/geolib/include/units.h>

#include <opencv2/opencv.hpp>

namespace maps::mrc {

class Camera {
public:
    const CameraParameters& parameters() const;

    void resetParameters(
        const CameraParameters& parameters,
        const cv::Size& imageSize);

    // Calibrates camera if some params were changed.
    // Returns true if calibration was done.
    bool calibrate(
        const std::string& sourceId,
        const std::string& model,
        const common::ImageOrientation& orientation,
        const db::CameraDeviation& cameraDeviation,
        const cv::Size& normalizedSize);

    // Estimate rotation angle of the camera based on vanishing point method.
    // The class handles a series of images and maintains the current angle.
    // consider new image (latest images have more weight)
    void estimateAngle(const cv::Mat& image);

    // @return camera angle CCW relative to the movement direction
    geolib3::Radians angle() const;

    const std::optional<cv::Point>& vanishingPoint() const;

private:
    void resetAngle();

    CameraParameters cameraParameters_;
    cv::Size size_;

    std::string sourceId_;
    std::string model_;
    common::ImageOrientation orientation_;
    db::CameraDeviation cameraDeviation_;

    geolib3::Radians angle_{0.};
    std::optional<cv::Point> vanishingPoint_;
    cv::Mat hist_;

    bool isCalibrated_ = false;
};

} // namespace maps::mrc
