#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/exif.h>

#include <opencv2/opencv.hpp>

namespace maps::mrc {

class CameraParameters {

public:
    cv::Mat cameraMatrix;           // 3 x 3 matrix
    cv::Mat distortionCoefficients; // 5 x 1 matrix
};

// At this moment it is possible to process images taken on a limited set of cameras:
// * SM_A720F
// * SM_A320F
// * ZE520KL
// For unknown model default camera parameters are returned.
CameraParameters getCameraParameters(
        const std::string& model,
        const common::ImageOrientation& orientation,
        const cv::Size& size);

} // namespace maps::mrc
