#pragma once
#include <maps/wikimap/mapspro/libs/tf_inferencer/maskrcnn_inferencer.h>

#include <opencv2/opencv.hpp>

namespace maps {
namespace mrc {
namespace carsegm {


class CarSegmentator {
public:
    CarSegmentator();

    /**
     * @brief Generate mask of cars for input image
     * @param image   input color image
     * @return result mask is one channel image with same sizes as input.
     *                pixel == 0 - if pixel not belongs to car
     *                pixel <> 0 - if pixel belongs to car
     */
     cv::Mat segment(const cv::Mat &image) const;

     std::vector<cv::Mat> segment(const std::vector<cv::Mat>& imagesBatch) const;

private:
    maps::wiki::tf_inferencer::MaskRCNNInferencer maskRCNNinferencer_;
};


} // carsegm
} // mrc
} // maps
