#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gtest/gtest.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/common/include/file_utils.h>
#include <maps/wikimap/mapspro/services/mrc/libs/carsegm/include/carsegm.h>

#include <opencv2/opencv.hpp>
#include <opencv2/imgcodecs/imgcodecs_c.h>

#include <fstream>
#include <iostream>
#include <sstream>
#include <vector>
#include <utility>
#include <unordered_set>

using namespace testing;

namespace maps {
namespace mrc {
namespace carsegm {

namespace tests {

namespace {

using ImageStringPair = std::pair<std::string, std::string>;

const std::vector<ImageStringPair> REFERENCE_IMAGES =
{
    {"car_segm_qvga.jpg", "car_segm_qvga.png"},
};

cv::Mat loadImage(const std::string& name, int flags) {
    static const std::string IMAGES_DIR =
        "maps/wikimap/mapspro/services/mrc/libs/carsegm/tests/images/";
    auto imagePath = static_cast<std::string>(BinaryPath(IMAGES_DIR + name));
    cv::Mat image = cv::imread(imagePath, flags);
    REQUIRE(image.data != nullptr, "Can't load image " << name);
    return image;
}

} // namespace

TEST(basic_tests, segm_cars_on_reference_images)
{
    CarSegmentator segmentator;
    for (size_t i = 0; i < REFERENCE_IMAGES.size(); i++){
        cv::Mat image = loadImage(REFERENCE_IMAGES[i].first, cv::IMREAD_COLOR);
        cv::Mat gtMask = loadImage(REFERENCE_IMAGES[i].second, cv::IMREAD_GRAYSCALE);
        cv::Mat tstMask = segmentator.segment(image);
        EXPECT_THAT(cv::norm(gtMask, tstMask), Le(1.0))
            << "mask for image: " << REFERENCE_IMAGES[i].first
            << " doesn't equal to ground truth";
    }
}

} // namespace test

} // namespace signdetect
} // namespace mrc
} // namespace maps
