#include "tf_classifier.h"

namespace maps::mrc::classifiers {

std::pair<std::string, float>
TensorFlowClassifier::callClassifier(const cv::Mat& image) const
{
    const std::string TF_INPUT_LAYER_NAME = "inference_input";
    const std::string TF_OUTPUT_SOFTMAX_LAYER_NAME = "inference_softmax";
    const std::string TF_OUTPUT_CLASS_NAMES_LAYER_NAME = "class_names";

    auto outputs = classifier_.inference(
        TF_INPUT_LAYER_NAME, image,
        std::vector<std::string>{TF_OUTPUT_SOFTMAX_LAYER_NAME,
                                 TF_OUTPUT_CLASS_NAMES_LAYER_NAME});

    ASSERT(outputs.size() == 2);

    auto confidences = outputs[0].matrix<float>();
    int64_t argmax = 0;
    float valmax = confidences(0, argmax);
    for (int64_t i = 1; i < confidences.dimension(1); ++i) {
        auto confidence = confidences(0, i);
        if (confidence > valmax) {
            valmax = confidence;
            argmax = i;
        }
    }

    std::string sign = outputs[1].vec<TString>()(argmax);
    return std::make_pair(sign, valmax);
}

} // namespace maps::mrc::classifiers
