#pragma once

#include <maps/wikimap/mapspro/libs/tf_inferencer/tf_inferencer.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/types.h>

#include <opencv2/opencv.hpp>

namespace maps::mrc::classifiers {

class ForbiddenClassifier
{
public:
    ForbiddenClassifier();

    /*
        Изображение в batch не обязаны быть одного размера,
        внутри всё масштабируется к нужному.
    */
    std::vector<double> estimateForbiddenProbability(const wiki::tf_inferencer::ImagesBatch &batch) const;

    double estimateForbiddenProbability(const cv::Mat& image) const;
    double estimateForbiddenProbability(const common::Bytes& encodedImage) const;
    double estimateForbiddenProbability(const common::Blob& encodedImage) const;
private:
    const wiki::tf_inferencer::TensorFlowInferencer inferencer_;
};

} // namespace maps::mrc::classifiers