#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>
#include <array>

namespace maps::mrc::classifiers {

/**
 * Calculate features for catboost classifier from neighbors of a given db::Feature
 * Classifier was trained on track points within 10 seconds from feature timestamp
 *
 * db::TrackPoints -- gps track points within 10 seconds
 * of the db::Feature of interest
 */
std::array<float, 8> calculatePositionFeatures(const db::TrackPoints&);


/**
 * Compute features with calculatePositionFeatures(const db::TrackPoints&)
 * and apply catboost model
 *
 * db::TrackPoints -- gps track points within 10 seconds
 * of the db::Feature of interest
 */
bool isPositionInaccurate(const db::TrackPoints&);

} // maps::mrc::classifiers
