#pragma once

#include "tf_classifier.h"

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/types.h>

#include <opencv2/opencv.hpp>

namespace maps::mrc::classifiers {

class QualityClassifier : public TensorFlowClassifier {
public:
    QualityClassifier();

    double estimateImageQuality(const cv::Mat& image) const;
    double estimateImageQuality(const common::Bytes& encodedImage) const;
    double estimateImageQuality(const common::Blob& encodedImage) const;

    // For tests only
    bool isImageHomogeneous(const cv::Mat& image) const;
};

} // namespace maps::mrc::classifiers
