#pragma once

#include <maps/wikimap/mapspro/libs/tf_inferencer/tf_inferencer.h>
#include <opencv2/opencv.hpp>

namespace maps::mrc::classifiers {

class TensorFlowClassifier {

public:
    explicit TensorFlowClassifier(const std::string& classifierPath)
        : classifier_(classifierPath)
    {}

    explicit TensorFlowClassifier(
        wiki::tf_inferencer::TensorFlowInferencer&& inferencer)
        : classifier_{std::move(inferencer)}
    {}

    std::pair<std::string, float> callClassifier(const cv::Mat& image) const;

private:
    const wiki::tf_inferencer::TensorFlowInferencer classifier_;
};

} // namespace maps::mrc::classifiers
