#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/types.h>

#include <opencv2/opencv.hpp>
#include <maps/libs/http/include/http.h>

namespace maps::mrc::classifiers {

class YavisionClassifier {
public:
    explicit YavisionClassifier(const http::URL& yavision)
        : yavisionUrl_(yavision)
    {}

    double estimateForbiddenProbability(const cv::Mat& image) const;
    double estimateForbiddenProbability(const common::Bytes& encodedImage) const;
    double estimateForbiddenProbability(const common::Blob& encodedImage) const;


    bool hasForbiddenContent(const common::Blob& encodedImage) const;

private:
    http::URL yavisionUrl_;
};

} // namespace maps::mrc::classifiers
