OWNER(comradeandrew)

LIBRARY()

ADDINCL(
    maps/wikimap/mapspro/services/mrc/libs/classifiers/include
    contrib/libs/opencv/include
    maps/wikimap/mapspro/libs/common/include
)

PEERDIR(
    contrib/libs/opencv
    contrib/libs/tf
    library/cpp/resource
    kernel/catboost
    maps/libs/http
    maps/libs/json
    maps/libs/log8
    maps/libs/geolib
    maps/wikimap/mapspro/libs/tf_inferencer
    maps/wikimap/mapspro/services/mrc/libs/common
    maps/wikimap/mapspro/services/mrc/libs/db
    maps/wikimap/mapspro/services/mrc/libs/sideview_classifier
)

SRCS(
    impl/tf_classifier.cpp
    impl/road_classifier.cpp
    impl/rotation_classifier.cpp
    impl/quality_classifier.cpp
    impl/yavision_classifier.cpp
    impl/position_accuracy_classifier.cpp
    impl/forbidden_classifier.cpp
)

BUILD_CATBOOST(position_accuracy.cbm positionAccuracyClassifier)

FROM_SANDBOX(FILE 656795310 OUT_NOAUTO road_classifier.gdef)
FROM_SANDBOX(FILE 2197327137 OUT_NOAUTO rotation_classifier.gdef)
FROM_SANDBOX(FILE 426602191 OUT_NOAUTO quality_classifier.gdef)
FROM_SANDBOX(FILE 1645244355 OUT_NOAUTO forbidden_classifier.gdef)

RESOURCE(
    road_classifier.gdef        /maps/mrc/classifiers/models/road_classifier.gdef
    rotation_classifier.gdef    /maps/mrc/classifiers/models/rotation_classifier.gdef
    quality_classifier.gdef     /maps/mrc/classifiers/models/quality_classifier.gdef
    forbidden_classifier.gdef   /maps/mrc/classifiers/models/forbidden_classifier.gdef
)

END()

RECURSE_FOR_TESTS(
    tests
)
