#pragma once

#include <boost/range/adaptor/sliced.hpp>

#include <algorithm>

namespace maps {
namespace mrc {
namespace common {

template <typename Container, typename Consumer>
void forEachBatch(Container&& container,
                  size_t batchSize,
                  const Consumer& consumer)
{
    size_t pos = 0;
    while (pos < container.size()) {
        auto previous = pos;
        pos += std::min(container.size() - pos, batchSize);
        auto range = boost::adaptors::slice(container, previous, pos);
        consumer(range.begin(), range.end());
    }
}

} // namespace common
} // namespace mrc
} // namespace maps
