#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/utility.h>

#include <chrono>
#include <algorithm>

namespace maps::mrc::common {
/*
    FeatureIt должны быть упорядочены по паре sourceId, timestamp

    FeatureIt разбиваются на "проезды" проезд содержит только features
    с одним и тем жe sourceId, упорядоченные по временной метке и такие
    что две последовательные feature отличаются не более чем на
    300 секунд

    Функтор f вызывается на каждом таком проезде и должен иметь сигнатуру:
        void f(FeatureIt begin, FeatureIt end);
*/
template <class FeatureIt, class Function>
void forEachPassage(FeatureIt first, FeatureIt last, Function f, const int timeGapSeconds = 300)
{
    const auto TIME_GAP = std::chrono::seconds{timeGapSeconds};
    auto equalPassage = [&](const auto& lhs, const auto& rhs) {
        return !lhs.sourceId().empty() &&  // db::feature::NO_SOURCE_ID
               lhs.sourceId() == rhs.sourceId() &&
               std::chrono::abs(lhs.timestamp() - rhs.timestamp()) <= TIME_GAP;
    };
    forEachEqualRange(first, last, equalPassage, f);
}

} // maps::mrc::common
