#pragma once

#include <maps/libs/common/include/exception.h>

#include <algorithm>
#include <random>

namespace maps::mrc::common {
/*
    Возвращает случайный набор указателей из отрезка от first до last.
*/
template <class FeatureIt>
std::vector<FeatureIt> sample(FeatureIt first, FeatureIt last, int samples = 5, int samples_frac = 20)
{
    REQUIRE(first != last, "Interval must not be empty" );

    const int totalCount = std::distance(first, last);

    std::vector<FeatureIt> result;
    if (totalCount <= samples) {
        for (auto it = first + 1; it != last; ++it) {
            result.push_back(it);
        }
    } else {
        const int needSamples = std::max(samples, totalCount / samples_frac);

        static std::mt19937 engine{std::random_device{}()};
        std::vector<FeatureIt> all;
        for (auto it = first + 1; it != last; ++it) {
            all.push_back(it);
        }
        std::sample(all.begin(), all.end(), std::back_inserter(result), needSamples,
                    engine);
    }
    return result;
}

} //namespace maps::mrc::common
