#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <sstream>
#include <string>

namespace maps::mrc::common {

enum class MdsObjectSource {
    Ugc,
    Ride,
    Drive,
    Walk,
    Imported,
};
DECLARE_ENUM_IO(MdsObjectSource);

enum class MdsObjectType {
    Image,
    Report,
    Video,
};
DECLARE_ENUM_IO(MdsObjectType);

namespace internal {

template<typename T>
class AddSlash {
public:
    AddSlash(const T& ref) : ref_(ref) { }
 
    friend std::ostream& operator<<(std::ostream& os, AddSlash<T> obj)
    {
        return os << "/" << obj.ref_;
    }
private:
    const T& ref_;
};

} // namespace internal

template <typename... Ids>
std::string makeMdsPath(
    MdsObjectSource source,
    MdsObjectType type,
    Ids... ids)
{
    std::ostringstream os;
    os << source << "/" << type;
    ( os << ... << internal::AddSlash(ids) );
    return os.str();
}

} // maps::mrc::common
