#pragma once

#include <opencv2/opencv.hpp>

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/types.h>

namespace maps {
namespace mrc {
namespace common {

Size sizeOf(const cv::Mat& mat);

/**
 * @return Evenly resized image such that it fits into a window with the
 *   provided size.
 * @note If the provided image smaller than the window, it is not scaled up.
 * @param image Image to fit into the window.
 * @param wndSize Size of the window to fit the image in.
 * @param interpolation Interpolation method as in cv::resize() function.
 */
cv::Mat fitImageTo(const cv::Mat& image, Size wndSize, int interpolation = cv::INTER_LINEAR);

/**
 * @return the image quality evaluation in the range [0(bad), 1(good)]
 * @param image image in JPEG format
 */
double estimateImageQuality(const Blob& image);

/**
 * @param image in-out parameter with image data
 * see description of equalizeHistogram(const Blob& image) function
 */
void equalizeHistogramBGR(cv::Mat& image);

/**
 * @return jpeg image buffer of image with equalized histogram
 * @param encodedImage image data
 */
Bytes equalizeHistogram(const Bytes& encodedImage);

/**
 * @return jpeg image buffer of image with equalized histogram in std::string
 * @param encodedImage image data
 */
Blob equalizeHistogram(const Blob& encodedImage);

/**
 * @param image image to blur an area in with Gaussian kernel
 * @param circumscribedRect axis aligned rectangle to inscribe a blurred ellipse in
 * @note the blured rectangle is clamped to the image borders
 */
void ellipticalBlur(cv::Mat& image, const cv::Rect& circumscribedRect);

/**
 * @return smallest png image buffer for tests
 */
template <typename T>
T getTestImage();

} // common
} // mrc
} // maps
