#pragma once

#include <boost/optional.hpp>

#include <string>

namespace maps {
namespace mrc {
namespace common {

/// Thread-safe local persistent storage based on SQLite database.
class PersistentQueue {
public:
    /// Open and/or create an SQLite database file as specified by the filename.
    explicit PersistentQueue(std::string path);

    boost::optional<std::string> pop();

    void push(const std::string& data);

    size_t size();

private:
    const std::string path_;
};

} // namespace common
} // namespace mrc
} // namespace maps
