#pragma once

#include <mutex>

namespace maps::mrc::common {

/**
 * Provides sequenced lifetime of objects the same type.
 * Must be the first base CRTP class in the inheritance list.
 * Based on RAII-style mechanism for owning a mutex.
 */
template <class>
class SequencedLifetimeGuard {
    inline static std::mutex guard_{};
    std::lock_guard<std::mutex> lock_;

public:
    SequencedLifetimeGuard() : lock_{guard_} {}
};

}  // namespace maps::mrc::common
