#pragma once

#include <maps/libs/chrono/include/time_point.h>

#include <utility>

namespace maps {
namespace mrc {
namespace common {

constexpr double NO_SUNRISE = -1.0; // Polar night
constexpr double NO_SUNSET = -2.0; // Polar day

/**
 * @brief Return sunrise and sunset times for a given point on Earth
 *        on the given date
 *
 * @param day day of the month, 1-based
 * @param month month of the year, 1-based
 * @param year year
 * @param lat latitude
 * @param lon longitude

 * @return pair of sunrise and sunset hours in UTC in [0, 24) interval.
 *
 *         if the Sun never rises on the specified date
 *         at the specified location, return {NO_SUNRISE, NO_SUNRISE}
 *
 *         if the Sun never sets on the specified date
 *         at the specified location, return {NO_SUNSET, NO_SUNSET}
 */
std::pair<double, double>
getSunriseSunsetHours(int day, int month, int year, double lat, double lon);


enum class DayPart : int8_t { Night, Day };

/**
 * @brief Return part of the day at the given point on Earth at the given time
 */
DayPart getDayPart(chrono::TimePoint timestamp, double lat, double lon);

} // common
} // mrc
} // maps
