#pragma once

#include <maps/libs/concurrent/include/queue.h>
#include <maps/libs/concurrent/include/threadpool.h>

namespace maps {
namespace mrc {
namespace common {

class ThreadpoolWrapper {
public:
    explicit ThreadpoolWrapper(size_t threadsNumber);

    explicit ThreadpoolWrapper(size_t threadsNumber, size_t queueSize);

    /// Rethrows first exception occurred in the threadpool
    void checkExceptions();

    /// Returns pointer to the underlying threadpool
    concurrent::ThreadPool* operator->() { return &threads_; }

    const concurrent::ThreadPool* operator->() const { return &threads_; }

private:
    concurrent::UnboundedBlockingQueue<std::exception_ptr> exceptions_;
    concurrent::ThreadPool threads_;
};

} // namespace common
} // namespace mrc
} // namespace maps
