#pragma once

#include <maps/libs/img/include/common.h>

#include <opencv2/opencv.hpp>
#include <opencv2/imgcodecs/imgcodecs_c.h>

#include <cstdint>
#include <string>
#include <vector>

namespace maps::mrc::common {

using Blob = std::string;

using Byte = uint8_t;
using Bytes = std::vector<Byte>;

using Size = img::IntegralSize;

Size getThumbnailSize(size_t width, size_t height);
Size getThumbnailSize(const Size& size);

template<typename TByteSequence>
Blob toBlob(const TByteSequence& bytes) { return Blob(bytes.begin(), bytes.end()); }

template<typename TByteSequence>
Bytes toBytes(const TByteSequence& bytes) { return Bytes(bytes.begin(), bytes.end()); }

cv::Mat decodeImage(const Bytes& bytes);
cv::Mat decodeImage(const Blob& blob);

// Encode 2D matrix to JPEG image.
Bytes encodeImage(const cv::Mat& image, int jpegLumaQuality = 0);

template <typename Int, typename Float>
Int round(Float val)
{
    return static_cast<Int>(std::round(val));
}

} // namespace maps::mrc::common
