#include <maps/wikimap/mapspro/services/mrc/libs/common/include/load.h>

#include <maps/libs/http/include/client.h>
#include <maps/libs/log8/include/log8.h>

namespace maps::mrc::common {

std::string load(const std::string& url, std::chrono::seconds timeout, size_t tryN)
{
    const auto policy = maps::common::RetryPolicy()
        .setTryNumber(tryN)
        .setInitialCooldown(std::chrono::seconds(60))
        .setCooldownBackoff(2.0);

    const auto [response, status] = http::Client{}
        .setTimeout(timeout)
        .get(url, policy);

    if (status == 200) {
        return response;
    }

    throw RuntimeError() << "Imposssible load " << url;
}

} // namespace maps::mrc::common

