#!/bin/bash

usage(){ echo "Usage: $0 <program>"; }
ok()   { echo "0;$*"; exit 0; }
fail() { echo "2;$*"; exit 2; }

check_status(){
    supervisorctl status $1 | grep -q "RUNNING" > /dev/null
    return $?
}

check_program(){
    prg=$1

    if [ -f /etc/supervisor/conf.d/${prg}.conf ]; then
      if check_status ${prg}; then
        ok "Ok";
      else
        fail "${prg} is not running";
      fi
    else
      fail "/etc/supervisor/conf.d/${prg}.conf not found";
    fi
}

if [ $# -ne 1 ]; then
   usage;
else
   check_program $1
fi
