#!/bin/bash

usage(){ echo "Usage: $0 <upstart-job>"; }
ok()   { echo "0;$*"; exit 0; }
warn() { echo "1;$*"; exit 1; }
fail() { echo "2;$*"; exit 2; }

check_upstart_service(){
    /sbin/status $1 | grep -q "^$1 start" > /dev/null
    return $?
}

check_service(){
    job=$1

    if [ -f /etc/init/${job}.conf ]; then
      if check_upstart_service ${job}; then
        ok "Ok";
      else
        fail "${job} is not running";
      fi
    else
      fail "No /etc/init/${job}.conf file found";
    fi
}

if [ $# -ne 1 ]; then
   usage;
else
   check_service $1
fi
