#pragma once

#include <maps/libs/common/include/exception.h>

#include <cstdint>

namespace maps {
namespace mrc {
namespace common {

/**
 * all rows within SQLite tables have a 64-bit signed integer key
 * @see https://www.sqlite.org/lang_createtable.html#rowid
 */
using SQLiteId = int64_t;

using SQLiteBlob = std::vector<uint8_t>;

class SQLiteError : public Exception {
    using Exception::Exception;
};

class SQLiteBusy : public SQLiteError {
    using SQLiteError::SQLiteError;
};

} // common
} // mrc
} // maps
