#include "sqlite_variant.h"

namespace maps {
namespace mrc {
namespace common {
namespace {

struct StringVisitor : boost::static_visitor<std::string> {
    std::string operator()(const None&) const
    {
        return std::string{};
    }

    template <typename T>
    std::string operator()(const T& from) const
    {
        return std::to_string(from);
    }

    std::string operator()(const std::string& from) const { return from; }

    std::string operator()(const SQLiteBlob&) const
    {
        throw SQLiteError{} << "BLOB to string conversion is not supported";
    }
};

} // anonymous namespace

std::string toString(const SQLiteVariant& from)
{
    return boost::apply_visitor(StringVisitor(), from);
}

} // common
} // mrc
} // maps
