#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gtest/gtest.h>

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/algorithm/collection.h>

namespace maps::mrc::common::tests {

TEST(makeRefMap_should, make_reference_map)
{
    std::vector<int> values{1, 2, 3, 4, 5};
    auto refMap = makeRefMap(values, [](int v){ return v;});

    EXPECT_EQ(refMap.size(), 5u);
    EXPECT_EQ(refMap.at(2), 2);

    values[1] = 0;
    EXPECT_EQ(refMap.at(2), 0);

    refMap.at(2).get() = 10;
    EXPECT_EQ(refMap.at(2), 10);
}

TEST(makeRefMap_should, make_const_reference_map)
{
    const std::vector<int> values{1, 2, 3, 4, 5};
    auto refMap = makeRefMap(values, [](int v){ return v;});

    EXPECT_EQ(refMap.size(), 5u);
    EXPECT_EQ(refMap.at(2), 2);
}

TEST(makeRefMap_should, throw_exception_on_duplicate)
{
    const std::vector<int> values{1, 2, 2, 4, 5};
    EXPECT_THROW(makeRefMap(values, [](int v){ return v;}),
        Exception);
}


} // namespace maps::mrc::common::tests
