#include <library/cpp/testing/gtest/gtest.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/algorithm/for_each_passage.h>

namespace maps::mrc::common::tests {

namespace {
    class DummyFeature {
    public:
        DummyFeature(int sourceId, const std::string& timestamp)
            : sourceId_(std::to_string(sourceId))
            , timestamp_(chrono::parseSqlDateTime(timestamp))
        {
        }
        const std::string& sourceId() const {
            return sourceId_;
        }
        chrono::TimePoint timestamp() const {
            return timestamp_;
        }
    private:
        std::string sourceId_;
        chrono::TimePoint timestamp_;
    };
} // anonymous namespace

TEST(for_each_passage, test_for_each_passage_basic) {
    std::vector<DummyFeature> features = {
        {0, "2000-01-01 00:00:00.000000+03"},
        {0, "2000-01-01 00:00:01.000000+03"},
        {0, "2000-01-01 00:00:02.000000+03"},
        {0, "2000-01-01 00:00:03.000000+03"},

        {0, "2000-01-01 01:00:00.000000+03"},
        {0, "2000-01-01 01:01:00.000000+03"},
        {0, "2000-01-01 01:02:00.000000+03"},
        {0, "2000-01-01 01:03:00.000000+03"},
        {0, "2000-01-01 01:04:00.000000+03"},
        {0, "2000-01-01 01:05:00.000000+03"},
        {0, "2000-01-01 01:06:00.000000+03"},
        {0, "2000-01-01 01:07:00.000000+03"},

        {1, "2000-01-01 01:08:00.000000+03"},
        {1, "2000-01-01 01:09:00.000000+03"},
        {1, "2000-01-01 01:10:00.000000+03"},
        {1, "2000-01-01 01:11:00.000000+03"},
        {1, "2000-01-01 01:12:00.000000+03"}
    };
    std::vector<ptrdiff_t> passagesSize = { 4, 8, 5};

    size_t passageIdx = 0;
    forEachPassage(
        features.begin(), features.end(), [&](auto first, auto last) {
            EXPECT_EQ(passagesSize[passageIdx], last - first);
            passageIdx++;
    });
    EXPECT_EQ(passageIdx, 3u);
}

} // namespace maps::mrc::common::tests