#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/geometry.h>

#include <functional>

namespace maps::mrc::common::geometry::tests {

using namespace ::testing;

    TEST(subpolylines_operations_tests, precedes_test)
    {
        EXPECT_TRUE(precedes({{0, 0.}, {0, 0.5}}, {{0, 0.5}, {0, 1.}}));
        EXPECT_TRUE(precedes({{0, 0.}, {1, 0.5}}, {{2, 0.5}, {3, 1.}}));
        EXPECT_FALSE(precedes({{0, 0.5}, {0, 1}}, {{0, 0.}, {0, 0.5}}));
        EXPECT_FALSE(precedes({{0, 0.}, {0, 0.6}}, {{0, 0.5}, {0, 1.}}));
    }

    TEST(subpolylines_operations_tests, intersects_test)
    {
        EXPECT_FALSE(intersects({{0, 0.}, {0, 0.5}}, {{0, 0.5}, {0, 1.}}));
        EXPECT_FALSE(intersects({{0, 0.}, {1, 0.5}}, {{2, 0.5}, {3, 1.}}));
        EXPECT_TRUE(intersects({{0, 0.}, {0, 0.5}}, {{0, 0.2}, {0, 1.}}));
    }

    TEST(subpolylines_operations_tests, intersection_test)
    {
        EXPECT_EQ(intersection({{0, 0.}, {0, 0.6}}, {{0, 0.5}, {0, 1.}}),
            SubPolyline({0, 0.5}, {0, 0.6}));
    }

    TEST(subpolylines_operations_tests, merge_test)
    {
        EXPECT_THAT(
            merge({{{0, 0.}, {0, 0.5}}, {{0, 0.5}, {0, 1.}}}),
            ContainerEq(SubPolylines({{{0, 0.}, {0, 1.}}}))
        );

        EXPECT_THAT(
            merge({{{0, 0.}, {0, 0.7}}, {{0, 0.5}, {0, 1.}}}),
            ContainerEq(SubPolylines({{{0, 0.}, {0, 1.}}}))
        );

        EXPECT_THAT(
            merge({{{0, 0.}, {0, 1}}, {{1, 0}, {1, 1.}}}),
            ContainerEq(SubPolylines({{{0, 0.}, {1, 1.}}}))
        );

        EXPECT_THAT(
            merge({{{0, 0.}, {1, 1}}, {{0, 0.5}, {1, 0.5}}}),
            ContainerEq(SubPolylines({{{0, 0.}, {1, 1.}}}))
        );
    }

    TEST(subpolylines_with_values_tests, merge_tests) {
        using SV = SubPolylineWithValue<int>;
        using SVs = std::vector<SV>;
        std::less<int> cmp;
        EXPECT_THAT(
            merge(
                SVs{
                    {{{0, 0.}, {1, 1.}}, 1},
                    {{{2, 0.}, {3, 1.}}, 2},
                },
                cmp),
            ContainerEq(
                SVs{
                    {{{0, 0.}, {1, 1.}}, 1},
                    {{{2, 0.}, {3, 1.}}, 2},
                })
        );

        EXPECT_THAT(
            merge(
                SVs{
                    {{{0, 0.}, {1, 1.}}, 2},
                    {{{0, 0.}, {1, 1.}}, 1},
                    {{{0, 0.}, {1, 1.}}, 3},
                },
                cmp),
            ContainerEq(
                SVs{
                    {{{0, 0.}, {1, 1.}}, 3},
                })
        );

        EXPECT_THAT(
            merge(
                SVs{
                    {{{0, 0.}, {3, 1.}}, 1},
                    {{{0, 0.5}, {1, 1.}}, 2},
                    {{{1, 0.5}, {2, 1.}}, 3},
                },
                cmp),
            ContainerEq(
                SVs{
                    {{{0, 0.}, {0, 0.5}}, 1},
                    {{{0, 0.5}, {1, 0.5}}, 2},
                    {{{1, 0.5}, {2, 1}}, 3},
                    {{{2, 1}, {3, 1}}, 1},
                })
        );
    }

} // namespace maps::mrc::common::geometry::tests
