#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/mds_path.h>

#include <iostream>

namespace maps::mrc::common::tests {

TEST(mds_path, basic_test) {
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Ugc, MdsObjectType::Image, 1), "ugc/images/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Ugc, MdsObjectType::Report, 1), "ugc/reports/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Ugc, MdsObjectType::Video, 1), "ugc/videos/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Ride, MdsObjectType::Image, 1), "ride/images/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Ride, MdsObjectType::Report, 1), "ride/reports/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Ride, MdsObjectType::Video, 1), "ride/videos/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Drive, MdsObjectType::Image, 1), "drive/images/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Drive, MdsObjectType::Report, 1), "drive/reports/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Drive, MdsObjectType::Video, 1), "drive/videos/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Walk, MdsObjectType::Image, 1), "walk/images/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Walk, MdsObjectType::Report, 1), "walk/reports/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Walk, MdsObjectType::Video, 1), "walk/videos/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Imported, MdsObjectType::Image, 1), "imported/images/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Imported, MdsObjectType::Report, 1), "imported/reports/1");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Imported, MdsObjectType::Video, 1), "imported/videos/1");

    EXPECT_EQ(makeMdsPath(MdsObjectSource::Ugc, MdsObjectType::Report, 1, 2, 3), "ugc/reports/1/2/3");
    EXPECT_EQ(makeMdsPath(MdsObjectSource::Ugc, MdsObjectType::Image, "catch", 22), "ugc/images/catch/22");
}

} // namespace maps::mrc::common::tests
