#pragma once

#include <maps/libs/stringutils/include/split.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/panorama_utils.h>

#include <boost/lexical_cast.hpp>

namespace maps::mrc::common::tests {

class PanoTilesDownloaderMock : public PanoTilesDownloader {
public:
    PanoTilesDownloaderMock(PanoTiles tiles = {})
        : PanoTilesDownloader{"http://dummy_s3_mds_url", "dummy_mds_key"}
        , srcTiles_(std::move(tiles))
    {}

    void requestTile(const RequestContext& context) override
    {
        requestsContext_.push_back(&context);
    };

    PanoTiles getTiles(uint32_t vTilesCount, uint32_t hTilesCount) override
    {
        using namespace maps::stringutils;

        PanoTiles panoTiles{vTilesCount, PanoTilesLine{hTilesCount}};

        for (const auto& context: requestsContext_) {
            auto tileCoords = split(split(context->tileUrl, '/').back(), '.');
            REQUIRE(tileCoords.size() == 3, "Invalid tile URL");
            REQUIRE(
                context->y < panoTiles.size() &&
                    context->x < panoTiles[context->y].size(),
                "Invalid resulting tiles grid or an erroneous tile "
                "index");

            std::uint32_t srcX =
                boost::lexical_cast<std::uint32_t>(tileCoords[1]);
            std::uint32_t srcY =
                boost::lexical_cast<std::uint32_t>(tileCoords[2]);
            panoTiles[context->y][context->x] = srcTiles_[srcY][srcX];
        }

        requestsContext_.clear();
        return panoTiles;
    }

private:
    const PanoTiles srcTiles_;
    std::vector<const RequestContext*> requestsContext_;
};

} // namespace maps::mrc::common::tests
