#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/algorithm/sample.h>

#include <iostream>

namespace maps::mrc::common::tests {

TEST(sample, sample_basic) {
    constexpr int SAMPLES_FRAC = 20;

    std::vector<int> small(5);
    std::vector<int> big(1000);

    EXPECT_EQ(sample(small.begin(), small.end()).size(), small.size() - 1);
    EXPECT_EQ((int)sample(big.begin(), big.end()).size(), (int)big.size() / SAMPLES_FRAC);
}

} // namespace maps::mrc::common::tests