#include <library/cpp/testing/gtest/gtest.h>

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/stopwatch.h>

namespace maps::mrc::common::tests {

using namespace testing;

TEST(IntervalsTimer_should, print_one_interval)
{
    IntervalsTimer timer("Call");
    EXPECT_THAT(timer.toString(), MatchesRegex(
        R"(Call 0+ms \(\))"));
    timer.endInterval("first");
    EXPECT_THAT(timer.toString(), MatchesRegex(
        R"(Call [0-9]+ms \(first [0-9]+ms\))"));
}


TEST(IntervalsTimer_should, print_many_intervals)
{
    IntervalsTimer timer("Call");
    EXPECT_THAT(timer.toString(), MatchesRegex(
        R"(Call 0ms \(\))"));
    timer.endInterval("first");
    EXPECT_THAT(timer.toString(), MatchesRegex(
        R"(Call [0-9]+ms \(first [0-9]+ms\))"));
    timer.endInterval("second");
    EXPECT_THAT(timer.toString(), MatchesRegex(
        R"(Call [0-9]+ms \(first [0-9]+ms \+ second [0-9]+ms\))"));
}



} // namespace maps::mrc::common::tests
