#include <maps/wikimap/mapspro/services/mrc/libs/common/include/threadpool_wrapper.h>

namespace maps {
namespace mrc {
namespace common {

ThreadpoolWrapper::ThreadpoolWrapper(size_t threadsNumber)
    : ThreadpoolWrapper(threadsNumber, threadsNumber)
{
}

ThreadpoolWrapper::ThreadpoolWrapper(size_t threadsNumber, size_t queueSize)
    : threads_{
        concurrent::ThreadsNumber(threadsNumber),
        concurrent::QueueCapacity(queueSize)
    }
{
    threads_.setErrorHandler([this](const std::exception&) {
        exceptions_.push(std::current_exception());
    });
}

void ThreadpoolWrapper::checkExceptions() {
    if (auto maybeException = exceptions_.tryPop()) {
        std::rethrow_exception(*maybeException);
    }
}

} // namespace common
} // namespace mrc
} // namespace maps
