#include <maps/libs/common/include/file_utils.h>
#include <maps/libs/vault_boy/include/secrets.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/wiki_config.h>

#include <boost/algorithm/string.hpp>
#include <boost/filesystem.hpp>

namespace maps::mrc::common {

wiki::common::ExtendedXmlDoc makeWikiConfig(
    const std::string& templateConfigDir)
{
    auto env = maps::common::readFileToString("/etc/yandex/environment.alias");
    boost::trim(env);
    auto cfgFile = (boost::filesystem::path(templateConfigDir) /
                    std::string{"services." + env + ".xml"});
    auto ctx =
        vault_boy::DirectoryContext{vault_boy::defaultPath("wiki/services")};
    return wiki::common::ExtendedXmlDoc{
        ctx.renderTemplate(maps::common::readFileToString(cfgFile.string())),
        wiki::common::ExtendedXmlDoc::SourceType::XmlString};
}

}  // namespace maps::mrc::common
