#pragma once
#include <maps/wikimap/mapspro/libs/tf_inferencer/tf_inferencer.h>
#include <opencv2/opencv.hpp>

namespace maps {
namespace mrc {
namespace coord_recognition {

struct Coordinates {
    double first;
    double second;
    double confidence;
};

// строка символов + вектор коэффициентов уверености по одному для каждого символа
struct RecognizedLine {
    std::string str;
    std::vector<float> confidences;
};

/*
    Класс реализует крайне специфичный сценарий распознавания.
    На картинке сверху должна быть белая полоса с одной или несколькими
    строками текста в одной из строк должны идти координаты снимка в формате:
        /DD°MM.MMMM',DD°MM.MMMM'

    CoordRecognition::recognize
        1. находит строки сверху изображения
        2. разбивает их на символы
        3. распознает каждый символ при помощи очень простой, специально на таком
        наборе натренированной нейронной сети.
        4. Пытается выделить паттерн, соответствующий координатам
        5. Переводит градусы и минуты в число с плавающей точкой
        6. Возвращает пару координат и коэффициент уверенности (от 0. до 1.)

    Замечание:
        координаты на видео (тех которые посмотрел) идут в порядке latitude, longitude,
        соответственно в Coordinates они помещаются в том же порядке
            Coordinates::first  - latitude
            Coordinates::second  - longitude
*/
class CoordRecognition {
public:
    CoordRecognition();

    Coordinates recognize(const cv::Mat &image) const;
private:
    void evalSupportedSymbols();

    /*
        Просто вызываем на пачке изображений сеть распознающую символы
    */
    RecognizedLine recognizeSymbols(const wiki::tf_inferencer::ImagesBatch &imagesBatch) const;

    /*
        Получает на вход картинку текстовой строки в градациях серого
        На выход отдаёт распознанную строку (символы, которых нет в наборе на
        котором тренировалась сеть заменяются пробелами) и вектор коэффициентов
        уверенности по одному для каждого символа
    */
    RecognizedLine recognizeTextLine(const cv::Mat& grayLine) const;
private:
    wiki::tf_inferencer::TensorFlowInferencer tfInferencer_;

    std::string symbols_;
};


} // coord_recognition
} // mrc
} // maps
