#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/assignment_gateway.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/assignment_review_gateway.h>

namespace maps::mrc::db::ugc {

TIds AssignmentGateway::loadIdsOrderByUpdateTimeDesc(size_t offset, size_t limit) {
    std::ostringstream query;
    query << " SELECT assignment_id FROM " << Tb::name_
        << " LEFT JOIN " << table::AssignmentReview::name_
        << " USING ( assignment_id ) "
        << " ORDER BY COALESCE( actualization_date, submitted_at, acquired_at) DESC NULLS LAST "
        << " OFFSET " << offset << " ROWS FETCH NEXT " << limit << " ROWS ONLY ";
    return loadColumnByQuery(Tb::id, query.str());
}

} // namespace maps::mrc::db::ugc
