#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

namespace maps::mrc::db {

FeaturePrivacy selectStricterPrivacy(FeaturePrivacy lhs, FeaturePrivacy rhs) {
    return std::max(lhs, rhs);
}

std::string GeneralGeometryColumn::selectStatement() const
{
    return "ST_AsBinary(" + this->fullName().full() + ")";
}

std::string GeneralGeometryColumn::unescapeField(const sql_chemistry::ResultField& field) const
{
    return sql_chemistry::unescapeBytea(field);
}

std::string GeneralGeometryColumn::escapeValue(
    const std::string& val,
    sql_chemistry::Transaction& txn) const
{
    std::string result = "ST_GeomFromWKB('";
    result.append(txn.esc_raw(val));
    result.append("'::bytea,3395)");
    return result;
}

} // namespace maps::mrc::db
