#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/dataset.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/verification_source.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/verified_detection_missing_on_frame.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/hypothesis.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/object_in_photo.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/toloka/task.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/tasks_group.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/ugc/ugc.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/walk_object.h>

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::mrc::db {
using namespace std::string_view_literals;

constexpr enum_io::Representations<HypothesisType> HYPOTHESIS_TYPE_STRINGS{
    {HypothesisType::WrongSpeedLimit, "wrong_speed_limit"sv},
    {HypothesisType::AbsentParking, "absent_parking"sv},
    {HypothesisType::WrongParkingFtType, "wrong_parking_ft_type"sv},
    {HypothesisType::TrafficSign, "traffic_sign"sv},
    {HypothesisType::WrongDirection, "wrong_direction"sv},
    {HypothesisType::ProhibitedPath, "prohibited_path"sv},
};

DEFINE_ENUM_IO(HypothesisType, HYPOTHESIS_TYPE_STRINGS);

constexpr enum_io::Representations<WalkFeedbackType> WALK_FEEDBACK_TYPE_STRINGS{
    {WalkFeedbackType::None, "none"sv},
    {WalkFeedbackType::Barrier, "barrier"sv},
    {WalkFeedbackType::Other, "other"sv},
    {WalkFeedbackType::BuildingEntrance, "building_entrance"sv},
    {WalkFeedbackType::AddressPlate, "address_plate"sv},
    {WalkFeedbackType::EntrancePlate, "entrance_plate"sv},
    {WalkFeedbackType::BusinessSign, "business_sign"sv},
    {WalkFeedbackType::BusinessWorkingHours, "business_working_hours"sv},
    {WalkFeedbackType::FootPath, "foot_path"sv},
    {WalkFeedbackType::CyclePath, "cycle_path"sv},
    {WalkFeedbackType::Stairs, "stairs"sv},
    {WalkFeedbackType::Ramp, "ramp"sv},
    {WalkFeedbackType::Room, "room"sv},
    {WalkFeedbackType::Wall, "wall"sv},
    {WalkFeedbackType::Organization, "organization"sv},
    {WalkFeedbackType::Fence, "fence"sv},
    {WalkFeedbackType::Building, "building"sv},
    {WalkFeedbackType::Parking, "parking"sv}
};

DEFINE_ENUM_IO(WalkFeedbackType, WALK_FEEDBACK_TYPE_STRINGS);

constexpr enum_io::Representations<ObjectActionType> OBJECT_ACTION_TYPE_STRINGS{
    {ObjectActionType::Add, "add"sv},
    {ObjectActionType::Remove, "remove"sv},
};

DEFINE_ENUM_IO(ObjectActionType, OBJECT_ACTION_TYPE_STRINGS);

constexpr enum_io::Representations<ObjectStatus> OBJECT_STATUS_STRINGS{
    {ObjectStatus::Pending, "pending"sv},
    {ObjectStatus::Discarded, "discarded"sv},
    {ObjectStatus::WaitPublishing, "wait_publishing"sv},
    {ObjectStatus::Published, "published"sv},
    {ObjectStatus::Failed, "failed"sv},
    {ObjectStatus::Delayed, "delayed"sv},
};

DEFINE_ENUM_IO(ObjectStatus, OBJECT_STATUS_STRINGS);

constexpr enum_io::Representations<ObjectInPhotoType> OBJECT_IN_PHOTO_TYPE_STRINGS{
    {ObjectInPhotoType::Face, "face"sv},
    {ObjectInPhotoType::LicensePlate, "license_plate"sv},
};

DEFINE_ENUM_IO(ObjectInPhotoType, OBJECT_IN_PHOTO_TYPE_STRINGS);

constexpr enum_io::Representations<FeaturePrivacy> FEATURE_PRIVACY_STRINGS{
    {FeaturePrivacy::Public, "public"sv},
    {FeaturePrivacy::Restricted, "restricted"sv},
    {FeaturePrivacy::Secret, "secret"sv},
};

DEFINE_ENUM_IO(FeaturePrivacy, FEATURE_PRIVACY_STRINGS);

constexpr enum_io::Representations<GraphType> GRAPH_TYPE_STRINGS{
    {GraphType::Road, "road"sv},
    {GraphType::Pedestrian, "pedestrian"sv},
};

DEFINE_ENUM_IO(GraphType, GRAPH_TYPE_STRINGS);

constexpr enum_io::Representations<DisqType> DISQ_TYPE_STRINGS{
    {DisqType::DisableCapturing, "disable_capturing"sv},
    {DisqType::DisablePublishing, "disable_publishing"sv},
};

DEFINE_ENUM_IO(DisqType, DISQ_TYPE_STRINGS);

constexpr enum_io::Representations<RideStatus> RIDE_STATUS_STRINGS{
    {RideStatus::Pending, "pending"sv},
    {RideStatus::Processed, "processed"sv},
};

DEFINE_ENUM_IO(RideStatus, RIDE_STATUS_STRINGS);

constexpr enum_io::Representations<Dataset> DATASET_STRINGS{
    {Dataset::Agents, "agents"sv},
    {Dataset::Drive, "drive"sv},
    {Dataset::Rides ,"rides"sv},
    {Dataset::Walks ,"walks"sv},
    {Dataset::Video ,"video"sv},
    {Dataset::Tehran, "tehran"sv},
    {Dataset::PedestrianTask, "pedestrian_task"sv},
    {Dataset::BackofficeObject, "backoffice_object"sv},
    {Dataset::BackofficePhoto, "backoffice_photo"sv},
    {Dataset::AltayPedestrians, "altay_pedestrians"sv},
    {Dataset::YangPedestrians, "yang_pedestrians"sv},
    {Dataset::NexarDashcams, "nexar_dashcams"sv},
    {Dataset::TaxiSignalQ2, "taxi_signal_q2"sv},
    {Dataset::TolokaPedestrians, "toloka_pedestrians"sv},
};

DEFINE_ENUM_IO(Dataset, DATASET_STRINGS);

namespace ugc {

constexpr enum_io::Representations<TasksGroupStatus> TASKS_GROUP_STATUS_STRINGS{
    {TasksGroupStatus::Draft, "draft"sv},
    {TasksGroupStatus::Open, "open"sv},
    {TasksGroupStatus::Generating, "generating"sv},
    {TasksGroupStatus::InProgress, "in_progress"sv},
    {TasksGroupStatus::Closed, "closed"sv},
    {TasksGroupStatus::Failed, "failed"sv}
};

DEFINE_ENUM_IO(TasksGroupStatus, TASKS_GROUP_STATUS_STRINGS);

constexpr enum_io::Representations<TaskStatus> TASK_STATUS_STRINGS{
    {TaskStatus::Draft, "draft"sv},
    {TaskStatus::New, "new"sv},
    {TaskStatus::Acquired, "acquired"sv},
    {TaskStatus::Done, "done"sv},
};

DEFINE_ENUM_IO(TaskStatus, TASK_STATUS_STRINGS);

constexpr enum_io::Representations<Traffic> TRAFFIC_STRINGS{
    {Traffic::RightHand, "right-hand"sv},
    {Traffic::LeftHand, "left-hand"sv}
};

DEFINE_ENUM_IO(Traffic, TRAFFIC_STRINGS);

constexpr enum_io::Representations<Direction> DIRECTION_STRINGS{
    {Direction::Forward, "forward"sv},
    {Direction::Backward, "backward"sv},
    {Direction::Bidirectional, "bidirectional"sv}
};

DEFINE_ENUM_IO(Direction, DIRECTION_STRINGS);

constexpr enum_io::Representations<AssignmentStatus> ASSIGNMENT_STATUS_STRINGS{
    {AssignmentStatus::Active, "active"sv},
    {AssignmentStatus::Abandoned, "abandoned"sv},
    {AssignmentStatus::Completed, "completed"sv},
    {AssignmentStatus::Accepted, "accepted"sv},
    {AssignmentStatus::Revoked, "revoked"sv}
};

DEFINE_ENUM_IO(AssignmentStatus, ASSIGNMENT_STATUS_STRINGS);

constexpr enum_io::Representations<EstimatedPositionSource> ESTIMATED_POSITION_SOURCE_STRINGS{
    {EstimatedPositionSource::Error, "error"sv},
    {EstimatedPositionSource::Graph, "graph"sv},
    {EstimatedPositionSource::Track, "track"sv},
    {EstimatedPositionSource::Client, "client"sv}
};

DEFINE_ENUM_IO(EstimatedPositionSource, ESTIMATED_POSITION_SOURCE_STRINGS);

constexpr enum_io::Representations<TolokaStatus> TOLOKA_STATUS_STRINGS{
    {TolokaStatus::InProgress, "in-progress"sv},
    {TolokaStatus::Accepted, "accepted"sv},
    {TolokaStatus::Rejected, "rejected"sv}
};

DEFINE_ENUM_IO(TolokaStatus, TOLOKA_STATUS_STRINGS);

constexpr enum_io::Representations<AssignmentObjectType> ASSIGNMENT_OBJECT_TYPE_STRINGS{
    {AssignmentObjectType::Barrier, "barrier"sv},
    {AssignmentObjectType::Deadend, "deadend"sv},
    {AssignmentObjectType::BadConditions, "bad_conditions"sv},
    {AssignmentObjectType::NoEntry, "no_entry"sv}
};

DEFINE_ENUM_IO(AssignmentObjectType, ASSIGNMENT_OBJECT_TYPE_STRINGS);

} //namespace ugc

namespace toloka {

constexpr enum_io::Representations<TaskStatus> TASK_STATUS_STRINGS{
    {TaskStatus::New, "new"sv},
    {TaskStatus::InProgress, "in-progress"sv},
    {TaskStatus::Finished, "finished"sv},
    {TaskStatus::Failed, "failed"sv},
    {TaskStatus::Free, "free"sv},
    {TaskStatus::Cancelling, "cancelling"sv},
    {TaskStatus::Cancelled, "cancelled"sv}
};

DEFINE_ENUM_IO(TaskStatus, TASK_STATUS_STRINGS);

constexpr enum_io::Representations<TaskType> TASK_TYPE_STRINGS{
    {TaskType::ImageQualityClassification, "image-quality-classification"sv},
    {TaskType::Approvement, "approvement"sv},
    {TaskType::Taxonomy, "taxonomy"sv},
    {TaskType::TrafficLightDetection, "traffic-light-detection"sv},
    {TaskType::HouseNumberDetection, "house-number-detection"sv},
    {TaskType::HouseNumberRecognition, "house-number-recognition"sv},
    {TaskType::DetectionPairMatch, "detection-pair-match"sv},
    {TaskType::DetectionMissingOnFrame, "detection-missing-on-frame"sv},
};

DEFINE_ENUM_IO(TaskType, TASK_TYPE_STRINGS);

constexpr enum_io::Representations<Platform> PLATFORM_STRINGS{
    {Platform::Toloka, "toloka"sv},
    {Platform::Yang, "yang"sv},
};

DEFINE_ENUM_IO(Platform, PLATFORM_STRINGS);

} // namespace toloka

namespace eye {

constexpr enum_io::Representations<HypothesisType> HYPOTHESIS_TYPE_STRINGS {
    {HypothesisType::AbsentTrafficLight, "absent_traffic_light"sv},
    {HypothesisType::AbsentHouseNumber, "absent_address"sv},
    {HypothesisType::WrongSpeedLimit, "wrong_speed_limit"sv},
    {HypothesisType::AbsentParking, "absent_parking"sv},
    {HypothesisType::WrongParkingFtType, "wrong_parking_ft_type"sv},
    {HypothesisType::TrafficSign, "traffic_sign"sv},
    {HypothesisType::WrongDirection, "wrong_direction"sv},
    {HypothesisType::ProhibitedPath, "prohibited_path"sv},
    {HypothesisType::LaneHypothesis, "lane_hypothesis"sv},
    {HypothesisType::SpeedBump, "speed_bump"sv},
    {HypothesisType::RailwayCrossing, "railway_crossing"sv},
};

DEFINE_ENUM_IO(HypothesisType, HYPOTHESIS_TYPE_STRINGS);

constexpr enum_io::Representations<ObjectType> OBJECT_TYPE_STRINGS {
    {ObjectType::TrafficLight, "traffic_light"sv},
    {ObjectType::Sign, "sign"sv},
    {ObjectType::RoadMarking, "road_marking"sv},
    {ObjectType::HouseNumber, "house_number"sv},
};

DEFINE_ENUM_IO(ObjectType, OBJECT_TYPE_STRINGS);

constexpr enum_io::Representations<RecognitionType> RECOGNITION_TYPE_STRINGS {
    {RecognitionType::DetectSign, "detect_sign"sv},
    {RecognitionType::DetectTrafficLight, "detect_traffic_light"sv},
    {RecognitionType::DetectRoadMarking, "detect_road_marking"sv},
    {RecognitionType::DetectHouseNumber, "detect_house_number"sv},
    {RecognitionType::DetectPanel, "detect_panel"sv}
};

DEFINE_ENUM_IO(RecognitionType, RECOGNITION_TYPE_STRINGS);

constexpr enum_io::Representations<RecognitionSource> RECOGNITION_SOURCE_STRINGS {
    {RecognitionSource::Import, "import"sv},
    {RecognitionSource::Model, "model"sv},
    {RecognitionSource::Toloka, "toloka"sv},
    {RecognitionSource::Yang, "yang"sv},
};

DEFINE_ENUM_IO(RecognitionSource, RECOGNITION_SOURCE_STRINGS);

constexpr enum_io::Representations<DetectionType> DETECTION_TYPE_STRINGS {
    {DetectionType::Sign, "sign"sv},
    {DetectionType::TrafficLight, "traffic_light"sv},
    {DetectionType::RoadMarking, "road_marking"sv},
    {DetectionType::HouseNumber, "house_number"sv},
};

DEFINE_ENUM_IO(DetectionType, DETECTION_TYPE_STRINGS);

constexpr enum_io::Representations<FrameSource> SOURCE_TYPE_STRINGS{
    {FrameSource::Mrc, "mrc"sv},
    {FrameSource::Panorama, "panorama"sv},
};

DEFINE_ENUM_IO(FrameSource, SOURCE_TYPE_STRINGS);

constexpr enum_io::Representations<VerificationSource> VERIFICATION_SOURCE_STRINGS {
    {VerificationSource::Toloka, "toloka"sv},
    {VerificationSource::Yang, "yang"sv},
    {VerificationSource::Nmaps, "nmaps"sv},
};

DEFINE_ENUM_IO(VerificationSource, VERIFICATION_SOURCE_STRINGS);

constexpr enum_io::Representations<VerifiedDetectionMissingOnFrameIsVisible> VERIFIED_DETECTION_MISSING_ON_FRAME_IS_VISIBLE_STRINGS {
    {VerifiedDetectionMissingOnFrameIsVisible::Yes, "yes"sv},
    {VerifiedDetectionMissingOnFrameIsVisible::No, "no"sv},
    {VerifiedDetectionMissingOnFrameIsVisible::Unknown, "unknown"sv},
};

DEFINE_ENUM_IO(VerifiedDetectionMissingOnFrameIsVisible, VERIFIED_DETECTION_MISSING_ON_FRAME_IS_VISIBLE_STRINGS);

constexpr enum_io::Representations<VerifiedDetectionMissingOnFrameMissingReason> VERIFIED_DETECTION_MISSING_ON_FRAME_MISSING_REASON_STRINGS {
    {VerifiedDetectionMissingOnFrameMissingReason::Missing, "missing"sv},
    {VerifiedDetectionMissingOnFrameMissingReason::Hidden, "hidden"sv},
    {VerifiedDetectionMissingOnFrameMissingReason::PlaceIsNotVisible, "place_is_not_visible"sv},
    {VerifiedDetectionMissingOnFrameMissingReason::Unknown, "unknown"sv},
};

DEFINE_ENUM_IO(VerifiedDetectionMissingOnFrameMissingReason, VERIFIED_DETECTION_MISSING_ON_FRAME_MISSING_REASON_STRINGS);

} // namespace eye

} // namespace maps::mrc::db
