#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/frame.h>

namespace maps::mrc::db::eye {

Device::Device(const DeviceAttrs& attrs): id_(0), txnId_(0), attrs_(attrs.json()) {}

DeviceAttrs Device::attrs() const { return DeviceAttrs(attrs_); }

Frame::Frame(
            TId deviceId,
            const common::ImageOrientation& orientation,
            const UrlContext& urlContext,
            const common::Size& originalSize,
            chrono::TimePoint time)
        : id_(0)
        , txnId_(0)
        , deviceId_(deviceId)
        , deleted_(false)
        , orientation_(static_cast<int>(orientation))
        , urlContext_(urlContext.json())
        , width_(originalSize.width)
        , height_(originalSize.height)
        , time_(time)
{
    static constexpr auto limit = std::numeric_limits<int16_t>::max();

    REQUIRE(
        originalSize.height <= limit and originalSize.width <= limit,
        "Invalid size " << originalSize
    );
}

UrlContext Frame::urlContext() const { return UrlContext(urlContext_); }

Frame& Frame::setUrlContext(const UrlContext& urlContext)
{
    urlContext_ = urlContext.json();
    return *this;
}

} // namespace maps::mrc::db::eye
