#include "yandex/maps/wiki/revision/revisionid.h"
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/hypothesis_attrs.h>

namespace maps::mrc::db::eye {

std::optional<wiki::revision::RevisionID> getRevisionId(const Hypothesis& hypothesis)
{
    switch (hypothesis.type()) {
        case HypothesisType::AbsentTrafficLight:
            return hypothesis.attrs<AbsentTrafficLightAttrs>().junctionRevisionId;
        case HypothesisType::WrongSpeedLimit:
            return hypothesis.attrs<WrongSpeedLimitAttrs>().roadElementRevisionId;
        case HypothesisType::WrongParkingFtType:
            return hypothesis.attrs<WrongParkingFtTypeAttrs>().parkingRevisionId;
        case HypothesisType::WrongDirection:
            return hypothesis.attrs<WrongDirectionAttrs>().roadElementRevisionId;
        case HypothesisType::AbsentParking:
            return hypothesis.attrs<AbsentParkingAttrs>().parkingRevisionId;
        case HypothesisType::SpeedBump:
            return hypothesis.attrs<SpeedBumpAttrs>().objectRevisionId;
        // do not dump objectId and commitId for lane hypothesis
        case HypothesisType::LaneHypothesis:
        // hypothesis with following types don't have objectId and commitId
        case HypothesisType::AbsentHouseNumber:
        case HypothesisType::ProhibitedPath:
        case HypothesisType::TrafficSign:
            return std::nullopt;
        default:
            throw maps::RuntimeError()
                << "Unknown hypothesis type " << hypothesis.type()
                << "(setObjectAndCommitId)";
    }
}

} // namespace maps::mrc::db::eye {
