#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object.h>

namespace maps::mrc::db::eye {

namespace {

bool hasEmptyAttrs(ObjectType type) {
    switch(type) {
        case ObjectType::TrafficLight: return true;
        default: return false;
    };
}

} // namespace

Object::Object(TId primaryDetectionId, ObjectType type)
    : primaryDetectionId_(primaryDetectionId)
    , type_(type)
{
    ASSERT(hasEmptyAttrs(type));
}

ObjectType toObjectType(DetectionType type)
{
    switch (type) {
        case DetectionType::Sign:
            return ObjectType::Sign;

        case DetectionType::TrafficLight:
            return ObjectType::TrafficLight;

        case DetectionType::RoadMarking:
            return ObjectType::RoadMarking;

        case DetectionType::HouseNumber:
            return ObjectType::HouseNumber;

        default:
            throw RuntimeError() << "Invalid detection type " << type;
    }
}

} // namespace maps::mrc::db::eye
