#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/object_attrs.h>

namespace maps::mrc::db::eye {

namespace {

const std::string TYPE = "type";
const std::string TEMPORARY = "temporary";
const std::string NUMBER = "number";

} // namespace

// Traffic light
TrafficLightAttrs TrafficLightAttrs::fromJson(const json::Value& value) {
    REQUIRE(value == json::Value{json::repr::ObjectRepr{}}, "Incorrect json");
    return TrafficLightAttrs{};
}

json::Value toJson(const TrafficLightAttrs& /*attrs*/) {
    return json::Value{json::repr::ObjectRepr{}};
}

// Sign
SignAttrs SignAttrs::fromJson(const json::Value& value) {
    return SignAttrs{
        traffic_signs::stringToTrafficSign(value[TYPE].as<std::string>()),
        value[TEMPORARY].as<bool>()
    };
}

json::Value toJson(const SignAttrs& attrs) {
    return json::Value{
        {TYPE, json::Value(traffic_signs::toString(attrs.type))},
        {TEMPORARY, json::Value(attrs.temporary)}
    };
}

// Road marking
RoadMarkingAttrs RoadMarkingAttrs::fromJson(const json::Value& value) {
    return RoadMarkingAttrs{
        traffic_signs::stringToTrafficSign(value[TYPE].as<std::string>())
    };
}

json::Value toJson(const RoadMarkingAttrs& attrs) {
    return json::Value{
        {TYPE, json::Value(traffic_signs::toString(attrs.type))}
    };
}

// House number
HouseNumberAttrs HouseNumberAttrs::fromJson(const json::Value& value) {
    return HouseNumberAttrs{
        value[NUMBER].as<std::string>()
    };
}

json::Value toJson(const HouseNumberAttrs& attrs) {
    return json::Value {
        {NUMBER, json::Value(attrs.number)}
    };
}

} // namespace maps::mrc::db::eye
