#include <maps/wikimap/mapspro/services/mrc/libs/db/include/eye/recognition.h>

#include <maps/libs/common/include/exception.h>

namespace maps::mrc::db::eye {

std::optional<DetectionType> toDetectionType(RecognitionType type)
{
    switch(type) {
        case RecognitionType::DetectSign:
            return DetectionType::Sign;

        case RecognitionType::DetectTrafficLight:
            return DetectionType::TrafficLight;

        case RecognitionType::DetectHouseNumber:
            return DetectionType::HouseNumber;

        case RecognitionType::DetectRoadMarking:
            return DetectionType::RoadMarking;

        default:
            return std::nullopt;
    }
}

RecognitionType toRecognitionType(DetectionType type)
{
    switch(type) {
        case DetectionType::Sign:
            return RecognitionType::DetectSign;

        case DetectionType::TrafficLight:
            return RecognitionType::DetectTrafficLight;

        case DetectionType::HouseNumber:
            return RecognitionType::DetectHouseNumber;

        case DetectionType::RoadMarking:
            return RecognitionType::DetectRoadMarking;

        default:
            throw RuntimeError() << "Unknown type " << type;
    }
}


Recognition::Recognition(
        TId frameId,
        const common::ImageOrientation& orientation,
        RecognitionType type,
        RecognitionSource source,
        int16_t version)
    : id_(0)
    , txnId_(0)
    , frameId_(frameId)
    , orientation_(static_cast<int16_t>(orientation))
    , type_(type)
    , source_(source)
    , version_(version)
    , value_()
{}

} // namespace maps::mrc::db::eye
